unit uInvDocs;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh, Vcl.StdCtrls,
  Vcl.ExtCtrls, EhLibVCL, GridsEh, DBAxisGridsEh, DBGridEh, Vcl.ToolWin,
  Vcl.ActnMan, Vcl.ActnCtrls, Vcl.ComCtrls, Data.DB, Data.Win.ADODB,
  System.UITypes;

type
  TfrmInvDocs = class(TForm)
    DocumentsDBGridEh: TDBGridEh;
    BottomPanel: TPanel;
    AddAktBtn: TButton;
    EditAktBtn: TButton;
    AktGB: TGroupBox;
    DeleteAktBtn: TButton;
    DeleteAkt: TADOQuery;
    SelectInvDocuments: TADOQuery;
    SelectInvDocumentscode: TIntegerField;
    SelectInvDocumentsdocDate: TDateTimeField;
    SelectInvDocumentsblankCode: TStringField;
    SelectInvDocumentsseria: TStringField;
    SelectInvDocumentsdocNumber: TStringField;
    SelectInvDocumentsDS: TDataSource;
    SelectInvDocumentsvalue: TStringField;
    SelectInvDocumentsvidDoc: TWordField;
    SelectInvDocumentsrefund: TBooleanField;
    SelectInvDocumentsadditionalValue: TStringField;
    procedure AddAktBtnClick(Sender: TObject);
    procedure DeleteAktBtnClick(Sender: TObject);
    procedure EditAktBtnClick(Sender: TObject);
    procedure SelectInvDocumentsAfterScroll(DataSet: TDataSet);
    procedure SelectInvDocumentsblankCodeChange(Sender: TField);
    procedure SelectInvDocumentsseriaChange(Sender: TField);
    procedure SelectInvDocumentsrefundChange(Sender: TField);
    procedure DocumentsDBGridEhCellClick(Column: TColumnEh);
    procedure SelectInvDocumentsadditionalValueChange(Sender: TField);
  private
    { Private declarations }
    idSender: Integer;
    compilingYear: Integer;
    number: Int64;
    procedure RefreshDocuments;
    procedure PostChanges;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent; idSender, compilingYear: Integer;
      number: Int64; invType: Byte); reintroduce;
  end;

var
  frmInvDocs: TfrmInvDocs;

implementation

uses
  uDM, uAddAkt, UtilUnit;

{$R *.dfm}

constructor TfrmInvDocs.Create(AOwner: TComponent; idSender, compilingYear:
  Integer; number: Int64; invType: Byte);
begin
  inherited Create(AOwner);

  Self.idSender := idSender;
  Self.compilingYear := compilingYear;
  Self.number := number;

  DocumentsDBGridEh.Columns.Items[5].Visible := invType in [2, 4];

  RefreshDocuments;
end;

procedure TfrmInvDocs.RefreshDocuments;
begin
  with SelectInvDocuments do
  begin
    Close;
    Parameters.ParamByName('sender').Value := Self.idSender;
    Parameters.ParamByName('year').Value := Self.compilingYear;
    Parameters.ParamByName('number').Value := Self.number;
    Open;
  end;
end;

procedure TfrmInvDocs.PostChanges;
begin
  if SelectInvDocuments.State in [dsEdit] then
    SelectInvDocuments.Post;
end;

procedure TfrmInvDocs.SelectInvDocumentsadditionalValueChange(Sender: TField);
begin
  PostChanges;
end;

procedure TfrmInvDocs.SelectInvDocumentsAfterScroll(DataSet: TDataSet);
var
  isActive: Boolean;
begin
  isActive := (SelectInvDocumentscode.AsInteger = 606) and (SelectInvDocumentsvidDoc.AsInteger = 7);

  EditAktBtn.Enabled := isActive;
  DeleteAktBtn.Enabled := isActive;
end;

procedure TfrmInvDocs.SelectInvDocumentsblankCodeChange(Sender: TField);
begin
  PostChanges;
end;

procedure TfrmInvDocs.SelectInvDocumentsrefundChange(Sender: TField);
begin
  PostChanges;
end;

procedure TfrmInvDocs.SelectInvDocumentsseriaChange(Sender: TField);
begin
  PostChanges;
end;

procedure TfrmInvDocs.AddAktBtnClick(Sender: TObject);
begin
  frmAddAkt := TfrmAddAkt.Create(Self, Self.idSender, Self.compilingYear, Self.number);

  if frmAddAkt.ShowModal = mrOK then
    RefreshDocuments;

  frmAddAkt.Free;
end;

procedure TfrmInvDocs.DeleteAktBtnClick(Sender: TObject);
begin
  try
    with DeleteAkt do
    begin
      Parameters.ParamByName('idSender').Value := idSender;
      Parameters.ParamByName('compilingYear').Value := compilingYear;
      Parameters.ParamByName('number').Value := number;
      Parameters.ParamByName('docNumber').Value := SelectInvDocumentsdocNumber.AsString;
      Parameters.ParamByName('docDate').Value := SelectInvDocumentsdocDate.AsDateTime;
      ExecSQL;
    end;

    RefreshDocuments;
  except
    on E: Exception do
      MessageDlg('   : ' + e.Message, mtError, [mbOK], 0);
  end;
end;

procedure TfrmInvDocs.DocumentsDBGridEhCellClick(Column: TColumnEh);
begin
  SelectInvDocumentsadditionalValue.ReadOnly := not ((Column.Index = 6) and (SelectInvDocumentscode.AsInteger
    = 601));
end;

procedure TfrmInvDocs.EditAktBtnClick(Sender: TObject);
begin
  frmAddAkt := TfrmAddAkt.Create(Self, Self.idSender, Self.compilingYear, Self.number,
    SelectInvDocumentsdocNumber.AsString, SelectInvDocumentsdocDate.AsDateTime);

  if frmAddAkt.ShowModal = mrOK then
    RefreshDocuments;

  frmAddAkt.Free;
end;

end.

